import react from "@vitejs/plugin-react-swc"
import { defineConfig, loadEnv } from "vite"
import tsconfigPaths from "vite-tsconfig-paths"
import { fileURLToPath } from 'node:url';
import svgr from 'vite-plugin-svgr'

import vitePluginInjectTags from './plugins/vite-plugin-inject-tags/index'

// https://vitejs.dev/config/
export default defineConfig(({ mode }) => {
  const env = loadEnv(mode, process.cwd(), 'CONFIG_');

  return {
    plugins: [
      svgr({
        svgrOptions: {
          icon: true,
        },
        include: "**/*.svg?react"
      }),
      react(),
      tsconfigPaths(),
      vitePluginInjectTags({
        allowedModes: ['staging', 'production'] satisfies ('staging' | 'production' | 'development')[],
        analytics: {
          id: env.CONFIG_GOOGLE_ANALYTICS_ID,
        }
      }),
      vitePluginInjectTags({
        allowedModes: ['development', 'production'] satisfies ('staging' | 'production' | 'development')[],
        tallySo: true,
      })
    ],
    build: {
      sourcemap: true,
      rollupOptions: {
        output: {
          manualChunks: nestedRouteName,
        },
      },

    },
    resolve: {
      extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json'],
      alias: {
        '@': fileURLToPath(new URL('./src', import.meta.url)),
      },
    },
  }
})

const nestedChunks = [
  ["src/aws", "aws"],
  ["@aws-sdk", "aws"],
  ["src/components/map/overlay/search", "aws"],
  ["src/hooks/use-app-loading", "aws"],
  ["leaflet/", "leaflet"],
  ["react-leaflet/", "leaflet"],
  ["src/components/map", "leaflet"],
  ["src/components/ui/leaflet", "leaflet"],
  ["src/hooks/use-current-location", "leaflet"],
  ["src/stores/route-store", "leaflet"],
  ["src/lib/utils", "leaflet"],
  ["src/main", "leaflet"],
]

/**
 * Given the file id, return the chunking alias. Splits larger chunks to below a certain threshold (based on build minified sizes).
 * __*Desired size should be under 500kB*__
 *
 * Funtion is intended to be used with the Rollup Output Configuration for manual chunks.
 * @param id
 */
function nestedRouteName(id: string): string | undefined {
  const find = nestedChunks.find((c) => {
    return id.includes(c[0])
  })

  if (find) {
    return find[1]
  }
}
